﻿-- Creating table 'GF_InternalTeamMember'
CREATE TABLE [dbo].[GF_InternalTeamMember] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [GF_InteralTeam_Id] int  NOT NULL,
    [Principal_PrincipalID] int  NOT NULL
);

-- Creating primary key on [Id] in table 'GF_InternalTeamMember'
ALTER TABLE [dbo].[GF_InternalTeamMember]
ADD CONSTRAINT [PK_GF_InternalTeamMember]
    PRIMARY KEY CLUSTERED ([Id] ASC);


-- Creating foreign key on [GF_InteralTeam_Id] in table 'GF_InternalTeamMember'
ALTER TABLE [dbo].[GF_InternalTeamMember]
ADD CONSTRAINT [FK_GF_InteralTeamGF_InternalTeamMember]
    FOREIGN KEY ([GF_InteralTeam_Id])
    REFERENCES [dbo].[GF_InteralTeam]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;


-- Creating non-clustered index for FOREIGN KEY 'FK_GF_InteralTeamGF_InternalTeamMember'
CREATE INDEX [IX_FK_GF_InteralTeamGF_InternalTeamMember]
ON [dbo].[GF_InternalTeamMember]
    ([GF_InteralTeam_Id]);

-- Creating foreign key on [Principal_PrincipalID] in table 'GF_InternalTeamMember'
ALTER TABLE [dbo].[GF_InternalTeamMember]
ADD CONSTRAINT [FK_PrincipalGF_InternalTeamMember]
    FOREIGN KEY ([Principal_PrincipalID])
    REFERENCES [dbo].[Principal]
        ([PrincipalID])
    ON DELETE CASCADE ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_PrincipalGF_InternalTeamMember'
CREATE INDEX [IX_FK_PrincipalGF_InternalTeamMember]
ON [dbo].[GF_InternalTeamMember]
    ([Principal_PrincipalID]);



--Creatgin FAQ tables--
IF OBJECT_ID(N'[dbo].[FK_FAQ_SetFAQ_Category]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[FAQ_Category] DROP CONSTRAINT [FK_FAQ_SetFAQ_Category];

IF OBJECT_ID(N'[dbo].[FK_FAQ_CategoryFAQ_Question]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[FAQ_Question] DROP CONSTRAINT [FK_FAQ_CategoryFAQ_Question];

IF OBJECT_ID(N'[dbo].[FK_FAQ_SetFAQ_View]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[FAQ_View] DROP CONSTRAINT [FK_FAQ_SetFAQ_View];

IF OBJECT_ID(N'[dbo].[FAQ_View]', 'U') IS NOT NULL
    DROP TABLE [dbo].[FAQ_View];

IF OBJECT_ID(N'[dbo].[FAQ_Set]', 'U') IS NOT NULL
    DROP TABLE [dbo].[FAQ_Set];

IF OBJECT_ID(N'[dbo].[FAQ_Category]', 'U') IS NOT NULL
    DROP TABLE [dbo].[FAQ_Category];

IF OBJECT_ID(N'[dbo].[FAQ_Question]', 'U') IS NOT NULL
    DROP TABLE [dbo].[FAQ_Question];


CREATE TABLE [dbo].[FAQ_View] (
    [Id] uniqueidentifier  NOT NULL,
    [WebpartId] nvarchar(max)  NOT NULL,
    [UseGlobalSet] bit  NOT NULL,
	[LastUpdated] datetime  NOT NULL,
    [PageUrl] nvarchar(max)  NOT NULL,
    [FAQ_Set_Id] uniqueidentifier  NOT NULL
);

CREATE TABLE [dbo].[FAQ_Set] (
    [Id] uniqueidentifier  NOT NULL,
    [Title] nvarchar(max)  NOT NULL,
    [IsGlobal] bit  NOT NULL
);

CREATE TABLE [dbo].[FAQ_Category] (
    [Id] uniqueidentifier  NOT NULL,
    [Title] nvarchar(max)  NOT NULL,
    [PictureUrl] nvarchar(max)  NULL,
    [IsRoot] bit  NOT NULL,
    [Order] int  NOT NULL,
    [FAQ_Set_Id] uniqueidentifier  NOT NULL
);

CREATE TABLE [dbo].[FAQ_Question] (
    [Id] uniqueidentifier  NOT NULL,
    [Question] nvarchar(max)  NOT NULL,
    [Answer] nvarchar(max)  NOT NULL,
    [IsTopFAQ] bit  NOT NULL,
    [Order] int  NOT NULL,
    [Icon] nvarchar(max)  NULL,
    [FAQ_Category_Id] uniqueidentifier  NOT NULL
);

ALTER TABLE [dbo].[FAQ_View]
ADD CONSTRAINT [PK_FAQ_View]
    PRIMARY KEY CLUSTERED ([Id] ASC);

ALTER TABLE [dbo].[FAQ_Set]
ADD CONSTRAINT [PK_FAQ_Set]
    PRIMARY KEY CLUSTERED ([Id] ASC);

ALTER TABLE [dbo].[FAQ_Category]
ADD CONSTRAINT [PK_FAQ_Category]
    PRIMARY KEY CLUSTERED ([Id] ASC);

ALTER TABLE [dbo].[FAQ_Question]
ADD CONSTRAINT [PK_FAQ_Question]
    PRIMARY KEY CLUSTERED ([Id] ASC);


ALTER TABLE [dbo].[FAQ_Category]
ADD CONSTRAINT [FK_FAQ_SetFAQ_Category]
    FOREIGN KEY ([FAQ_Set_Id])
    REFERENCES [dbo].[FAQ_Set]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;


CREATE INDEX [IX_FK_FAQ_SetFAQ_Category]
ON [dbo].[FAQ_Category]
    ([FAQ_Set_Id]);

ALTER TABLE [dbo].[FAQ_Question]
ADD CONSTRAINT [FK_FAQ_CategoryFAQ_Question]
    FOREIGN KEY ([FAQ_Category_Id])
    REFERENCES [dbo].[FAQ_Category]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;

CREATE INDEX [IX_FK_FAQ_CategoryFAQ_Question]
ON [dbo].[FAQ_Question]
    ([FAQ_Category_Id]);


ALTER TABLE [dbo].[FAQ_View]
ADD CONSTRAINT [FK_FAQ_SetFAQ_View]
    FOREIGN KEY ([FAQ_Set_Id])
    REFERENCES [dbo].[FAQ_Set]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;

CREATE INDEX [IX_FK_FAQ_SetFAQ_View]
ON [dbo].[FAQ_View]
    ([FAQ_Set_Id]);


exec sp_rename 'SiteCollectionRepositoryConfig', 'SiteRepositoryConfig'


